#!/bin/bash

# Experiment configuration
#tasks="cola mnli sst2 qqp qnli"
tasks="sst2"
m="pf2lora"
exp_name=roberta_lora_$task

lr=2e-3
epochs=4

WORKERS=8
NUM_GPUS=8
i=0
function rand(){
    min=$1
    max=$(($2-$min+1))
    num=$(($RANDOM+1000000000))
    echo $(($num%$max+$min))
}

port_num=$(rand 49152 65535)
# Execute command

for task in $tasks; do
  i=0
  while [ $i -lt $NUM_GPUS ]; do
        python train_dist.py \
        --name_or_path roberta-base \
        --world_size $WORKERS\
        --dataset $task\
        --seed 0 \
        --method $m\
        --lr_A 1e-3 \
        --lr_B $lr\
        --rank_max 12 \
        --rank_mat 8 \
        --rank_min 8 \
        --fp16 \
        --beta 0.0 \
        --gamma 0.99 \
        --lamb 0.001 \
        --num_epochs $epochs \
        --port  $port_num\
        --batch_size 16\
        --eval_batch_size 8\
        --com_interval 10 \
        --heterogeneity 0.6 \
        --num_gpu $NUM_GPUS \
        --gpu $i \
        --rank $i \
        --com_rounds 100\
        --inner_loops 1\
        --hessian_q 3 \
        --z_loops 5  &
      pids="${pids} $!"
      i=$(($i + 1))
  done
  echo "Running task $task with lr $lr and method $m on children pids: $pids"
  wait
done